#region References

using System;
using System.Diagnostics;
using System.Text;
using System.IO;
using System.Net.Sockets;
using gov.va.med.vbecs.Common.Log;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;

#endregion

namespace gov.va.med.VBECS.HL7Server.Core
{
	#region Header

		//<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		//<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		//<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		//<Developers>
		//	<Developer>Brian    lin</Developer>
		//</Developers>
		//<SiteName>Hines OIFO</SiteName>
		//<CreationDate>10/19/2004</CreationDate>
		//<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		// <summary>
		// This class is a simple wrapper around TcpClient that sends & receives 
		// HL7 messages. It terminates connection in case of errors and allows only 
		// one pair of "send-receive" or "receive-send" calls (RR stands for Request-Response).
		// </summary>

		#endregion

	/// <summary>
	/// Class HL7RRConnection
	/// </summary>
	public class HL7RRConnection : IDisposable	
	{
        // Events Logger: Aside note, please note that non of private fields (below) are used?! Remove then all?
        private static readonly ILogger _eventsLogger =
            LogManager.Instance().LoggerLocator.GetLogger("SystemEvents");


        private const string START_OF_TEXT_CHARACTER = "\x0B";
		private const string FILE_SEPARATOR_CHARACTER = "\x1C";
		private const string END_OF_TEXT_CHARACTER = "\x0D";

		private static readonly HL7ProtocolMessageFactory _messageFactory = new HL7ProtocolMessageFactory();

		///<Developers>
		///	<Developer>Brian    lin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7052"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>Valid instance of HL7RRConnection type</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7053"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// HL7RRConnection
		/// </summary>
		public HL7RRConnection() {}

		///<Developers>
		///	<Developer>Brian    lin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7058"> 
		///		<ExpectedInput>Not Testable</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7059"> 
		///		<ExpectedInput>NULL HL7ProtocolMessage parameter</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// SendMessage
		/// </summary>
		/// <param name="messageToSend"></param>
		/// <param name="s"></param>
		public static void SendMessage( HL7ProtocolMessage messageToSend, Socket s )
		{
			if( messageToSend == null )
				throw( new ArgumentNullException( "messageToSend" ) );

			try
			{
				byte[] _dataChunk = messageToSend.ToByteArray();
				s.Send( _dataChunk, 0, _dataChunk.Length, SocketFlags.None );
			}
			catch
			{
				throw;
			}
		}

		///<Developers>
		///	<Developer>Brian    lin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7056"> 
		///		<ExpectedInput>Untestable</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7057"> 
		///		<ExpectedInput>Untestable</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ReceiveMessage
		/// </summary>
		/// <param name="s"></param>
		/// <returns></returns>
		public static string ReceiveMessage(Socket s)
		{
			MemoryStream _ms;
			StringBuilder _msg;

			try
			{
				byte[] _receiveBuffer = new byte[1];
				_ms = new MemoryStream( _receiveBuffer.Length );
				_msg = new StringBuilder();
				bool _startBlockReceived = false;
				int _bytesRead = 0;
				for(;;)
				{
					_bytesRead = s.Receive( _receiveBuffer, 0, _receiveBuffer.Length, SocketFlags.None );
					
					if( _bytesRead <= 0 ) 					
						throw( new HL7Exception( "UnexpectedEOTOccured" ) );

					// Received start block but not end block
					if( _receiveBuffer[0] == Convert.ToByte( 11 ) )
					{
						_startBlockReceived = true;
					}

					// Received end block this time.  Write the rest to the stream and break out.
					if( _receiveBuffer[0] == Convert.ToByte( 28 ) )
					{
						break;
					}

						// Received something in between start and end block.  Highly unlikely!
					else if( _receiveBuffer[0] != Convert.ToByte( 11 ) && _startBlockReceived )
					{
						_msg.Append( Encoding.ASCII.GetChars( _receiveBuffer ) );
					}
				}
			}
			catch
			{
				throw;
			}

			return _msg.ToString();
		}

		///<Developers>
		///	<Developer>Brian    lin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7054"> 
		///		<ExpectedInput>Network client dependant. Unable to test.</ExpectedInput>
		///		<ExpectedOutput>Untestable</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7055"> 
		///		<ExpectedInput>null PING messge</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ReturnPing
		/// </summary>
		/// <param name="pingMessage"></param>
		/// <param name="s"></param>
		public static void ReturnPing(string pingMessage, Socket s)
		{
			if( pingMessage == null )
				throw( new ArgumentNullException( "pingMessage" ) );

			byte[] _dataChunk = Encoding.ASCII.GetBytes( pingMessage );

			if( s.Connected )
			{
				s.Send( _dataChunk );
			}
			else
			{
                // EventLogAppender
                _eventsLogger.Error(string.Format("{0}: {1}", "Send Error", "Socket is not connected"));
				//System.Diagnostics.EventLog.WriteEntry("Send Error", "Socket is not connected", EventLogEntryType.Error);
			}
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/16/2010</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="9000"> 
		///		<ExpectedInput>Valid</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="9001"> 
		///		<ExpectedInput>Invalid</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Dispose
		/// </summary>
		public void Dispose()
		{
			GC.SuppressFinalize( this );
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/16/2010</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8998"> 
		///		<ExpectedInput>Valid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8999"> 
		///		<ExpectedInput>Invalid</ExpectedInput>
		///		<ExpectedOutput></ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Desctructor
		/// </summary>
		~HL7RRConnection()
		{
			Dispose();
		}
	}
}
